#include <iostream>
#include <vector>
#include <algorithm>
#include <climits>

int main() {
    
    long long int N, M, K, L;
    std::cin >> N >> M >> K >> L;

    
    std::vector<long long int> A(N * M);
    for (long long int i = 0; i < N * M; i++) {
        std::cin >> A[i];
    }

    
    std::vector<std::vector<long long int>> matrixA(N, std::vector<long long int>(M));
    for (long long int i = 0; i < N; i++) {
        for (long long int j = 0; j < M; j++) {
            matrixA[i][j] = A[i * M + j];
        }
    }

    
    long long int max = LLONG_MIN;
    long long int maxRowIndex = 0;
    long long int maxColIndex = 0;
    for (long long int i = 0; i < N; i++) {
        for (long long int j = 0; j < M; j++) {
            if (matrixA[i][j] > max) {
                max = matrixA[i][j];
                maxRowIndex = i;
                maxColIndex = j;
            }
        }
    }

    
    long long int tmp = matrixA[N / 2][M / 2];
    matrixA[N / 2][M / 2] = max;
    matrixA[maxRowIndex][maxColIndex] = tmp;

    
    std::vector<std::vector<long long int>> sortedMatrix(N, std::vector<long long int>(M));
    for (long long int i = 0; i < N; i++) {
        std::sort(matrixA[i].begin(), matrixA[i].end());
        long long int idx = M / 2;
        for (long long int j = 0; j < M; j++) {
            sortedMatrix[i][j] = matrixA[i][(j + idx) % M];
        }
    }

    
    std::vector<std::vector<std::vector<long long int>>> submatrices(N - K + 1, std::vector<std::vector<long long int>>(M - L + 1, std::vector<long long int>(K * L)));
    for (long long int i = 0; i < N - K + 1; i++) {
        for (long long int j = 0; j < M - L + 1; j++) {
            for (long long int k = 0; k < K; k++) {
                for (long long int l = 0; l < L; l++) {
                    submatrices[i][j][k * L + l] = sortedMatrix[i + k][j + l];
                }
            }
        }
    }

    
    long long int totalSum = 0;
    for (long long int i = 0; i < N - K + 1; i++) {
        for (long long int j = 0; j < M - L + 1; j++) {
            for (long long int val : submatrices[i][j]) {
                totalSum += val;
            }
        }
    }

    std::cout << totalSum << std::endl;

    return 0;
}